// Alt-fire projectile class
class FishEgg extends Projectile;

var bool bCanHitOwner, bHitWater;
var float Count, SmokeRate;
var FishDec Embryo;
var FishGoop AltEmbryo;
var WeedBall OtherEmbryo;

simulated function PostBeginPlay()
{
	local vector X,Y,Z;
	local rotator RandRot;

	Super.PostBeginPlay();

	if ( Level.NetMode != NM_DedicatedServer )
		PlayAnim('Flying');

	SetTimer(2.5+FRand()*0.5,false);

	if ( Role == ROLE_Authority )
	{
		GetAxes(Instigator.ViewRotation,X,Y,Z);	
		Velocity = X * (Instigator.Velocity Dot X)*0.4 + Vector(Rotation) * (Speed +
			FRand() * 100);
		Velocity.z += 210;
		MaxSpeed = 1000;
		RandSpin(50000);	
		bCanHitOwner = False;
		if (Instigator.HeadRegion.Zone.bWaterZone)
		{
			bHitWater = True;
			Disable('Tick');
			Velocity=0.6*Velocity;			
		}
	}
	// spawns the wad of crap that makes the ball
	Embryo = Spawn(class'FishDec',Self,,Location,Rotation);
	Embryo.SetBase(Self);
	Embryo.SetOwner(Self);
	AltEmbryo = Spawn(class'FishGoop',Self,,Location,Rotation);
	AltEmbryo.SetBase(Self);
	AltEmbryo.SetOwner(Self);
	OtherEmbryo = Spawn(class'WeedBall',Self,,Location,Rotation);
	OtherEmbryo.SetBase(Self);
	OtherEmbryo.SetOwner(Self);
}

simulated function BeginPlay()
{
	if ( Level.bHighDetailMode && !Level.bDropDetail ) 
		SmokeRate = 0.03;
	else 
		SmokeRate = 0.15;
}

simulated function ZoneChange( Zoneinfo NewZone )
{
	local waterring w;
	
	if (!NewZone.bWaterZone || bHitWater) Return;

	bHitWater = True;
	w = Spawn(class'WaterRing',,,,rot(16384,0,0));
	w.DrawScale = 0.2;
	w.RemoteRole = ROLE_None;
	Velocity=0.6*Velocity;
}

simulated function Timer()
{
	Explosion(Location+Vect(0,0,1)*16);
}

simulated function Tick(float DeltaTime)
{
}

simulated function Landed( vector HitNormal )
{
	HitWall( HitNormal, None );
}

simulated function ProcessTouch( actor Other, vector HitLocation )
{
	if ( (Other!=instigator) || bCanHitOwner )
		Explosion(HitLocation);
}

simulated function HitWall( vector HitNormal, actor Wall )
{
	bCanHitOwner = True;
	Velocity = 0.75*(( Velocity dot HitNormal ) * HitNormal * (-2.0) + Velocity);   // Reflect off Wall w/damping
	RandSpin(100000);
	speed = VSize(Velocity);
	if ( Level.NetMode != NM_DedicatedServer )
		PlaySound(ImpactSound, SLOT_Misc, 1.5 );
	if ( Velocity.Z > 400 )
		Velocity.Z = 0.5 * (400 + Velocity.Z);	
	else if ( speed < 20 ) 
	{
		bBounce = False;
		SetPhysics(PHYS_None);
	}
}

// Lots of gibs, blood, green shit, and effects. Yeah, it's overdone so fuck off.
// You know you are going to steal it anyway ;)
function BlowUp(vector HitLocation)
{
	local int i;
	local vector v;
	local BloodDrop b;

	HurtRadius(damage, 200, MyDamageType, MomentumTransfer, HitLocation);
	MakeNoise(1.0);
	
   Spawn(class'UT_BigBloodHit',,, Location);
  	for (i=0; i<(6); i++)
	{
		v = Location;
		v.X += 10 * FRand();
		v.X -= 15 * FRand();
		v.Y += 10 * FRand();
		v.Y -= 15 * FRand();
		v.Z += 10 * FRand();
		v.Z -= 15 * FRand();
		Spawn(class'UT_BloodHit',,, v);
   }
	for (i=0; i<(3); i++)
   {
		v = Location;
		v.X += 5 * FRand();
		v.X -= 7 * FRand();
		v.Y += 5 * FRand();
		v.Y -= 7 * FRand();
		v.Z += 5 * FRand();
		v.Z -= 7 * FRand();
		Spawn(class'BloodBurst',,, v);

		v = Location;
		v.X += 7 * FRand();
		v.X -= 10 * FRand();
		v.Y += 7 * FRand();
		v.Y -= 10 * FRand();
		v.Z += 7 * FRand();
		v.Z -= 10 * FRand();
		Spawn(class'BloodBurst',,, v);
   }
 	for (i=0; i<(80); i++)
   {
		b = Spawn(class'BloodDrop',,, Location);
		b.Velocity = vector( RotRand() ) * ( FRand() * 200 );
		b.DrawScale *= 2 * Frand();
	}
	for (i=0; i<80; i++)
   {
		b = Spawn(class'BloodDrop',,, Location);
		b.Velocity.Z = i * 5;
		b.Velocity.X += (i / 7) * FRand();
		b.Velocity.X -= (i * 1.5 / 7) * FRand();
		b.Velocity.Y += (i / 7) * FRand();
		b.Velocity.Y -= (i * 1.5 / 7) * FRand();
		b.DrawScale += i * 0.00375 * FRand();
		b.bDecal = False;
	}
	for (i=0; i<3; i++)
		SpawnMyGibbedCarcass();
	Destroy();
}

function SpawnMyGibbedCarcass()
{
	local carcass carc;
	local int i;
	local vector v;
	
	for (i=0; i<(3); i++)
	{
		v = Location;
		v.X += 10 * FRand();
		v.X -= 15 * FRand();
		v.Y += 10 * FRand();
		v.Y -= 15 * FRand();
		v.Z += 10 * FRand();
		v.Z -= 15 * FRand();
	}

	carc = Spawn(class'GreenCarcass');
	if ( carc != None )
	{
		carc.Initfor(self);
		carc.ChunkUp(99999);
	}
}

simulated function Explosion(vector HitLocation)
{
	local UT_GreenGelPuff s;
	local Pupae NewBorn;

	BlowUp(HitLocation);
	if ( Level.NetMode != NM_DedicatedServer )
	{
		spawn(class'Botpack.BlastMark',,,,rot(16384,0,0));
  		s = spawn(class'UT_GreenGelPuff',,,HitLocation);
		s.RemoteRole = ROLE_None;
	}
	// Cleans up the fish ball when done
	If (Embryo != NONE) 
		Embryo.destroy();
	If (AltEmbryo != NONE)
		AltEmbryo.destroy();
	If (OtherEmbryo != NONE)
		OtherEmbryo.destroy();

 	Destroy();
}

defaultproperties
{
   speed=600.00
   MaxSpeed=1200.00
   Damage=60.00
   MomentumTransfer=150000
   MyDamageType=GrenadeDeath
   ImpactSound=Sound'UnrealI.BlobDeath'
   ExplosionDecal=Class'Botpack.BlastMark'
   Physics=PHYS_Falling
	RemoteRole=ROLE_SimulatedProxy
   AnimSequence=WingIn
   Style=STY_Modulated
   Texture=Texture'Botpack.Jgreen'
   Mesh=LodMesh'Botpack.BioGelm'
   DrawScale=1.00
   AmbientGlow=64
   bUnlit=True
   bMeshEnviroMap=True
   CollisionRadius=6.00
   CollisionHeight=6.00
   bBounce=True
   bFixedRotationDir=True
   DesiredRotation=(Pitch=12000,Yaw=5666,Roll=2334),
}
